% Model of a nonisothermal batch reactor - Alkylation
%                                          Two reactions

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dcdt = f(t,n,A,EA,B,H,m,Ac,U,Tc,Tin,ws,DH0,CpiC4,CpC4,CpiC8,CpiC12,DCp,nin,rho,M)

dcdt = zeros(6,1);     % Allocate space for the right-hand sides of the DEs

V = n(6);                    % Volume
cC4 = n(1)/V;                % Butene concentration
ciC4 = n(2)/V;               % Isobutane concentration
ciC8 = n(3)/V;               % Isooctane concentration
ciC12 = n(4)/V;              % Isododecane concentration
T = n(5);                    % Temperature

R = 8.314472;
k1 = A*exp(-EA/(R*T));       % Rate constants
K = B*exp(H/(R*T));
r1 = k1*cC4*ciC4/(ciC4 + ciC8 + K*cC4); % Reaction rate 1
r2 = k1*cC4*ciC8/(ciC4 + ciC8 + K*cC4); % Reaction rate 2

DH = DH0 + DCp*(T - 298.15);
q = U*Ac*(Tc - T);
Cpsum = V*(cC4*CpiC4 + ciC4*CpiC4 + ciC8*CpiC8 + ciC12*CpiC12);

Hin = -(T - Tin)*(nin(1)*CpC4 + nin(2)*CpiC4 + nin(3)*CpiC8 + nin(4)*CpiC12);

dcdt(1) = nin(1) - m*(r1 + r2);  % Differential equations for concentration
dcdt(2) = nin(2) - m*r1;
dcdt(3) = nin(3) + m*(r1 - r2);
dcdt(4) = nin(4) + m*r2;
dcdt(5) = (-m*(r1 + r2)*DH + Hin + ws + q)/Cpsum;
dcdt(6) = (M*transpose(nin))/rho;